/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationMessageRes;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskMessage;
import java.util.HashMap;
import java.util.Map;

public class PairingEditPanelBean
extends PanelBean
implements NotificationConstants {
    private Map data;
    private static final String TRACE_MASKT = "XNTYPEPT";
    private static final String TRACE_MASKF = "XNTYPEPF";
    private static final String TRACE_MASKD = "XNTYPEPD";
    private transient ItemDescriptor[] m_idSourcesTable;
    private transient ColumnDescriptor[] m_cdSourcesTableStructure;
    private int[] m_iSourcesTableSelection;
    private transient ItemDescriptor[] m_idSinksTable;
    private transient ColumnDescriptor[] m_cdSinksTableStructure;
    private int[] m_iSinksTableSelection;
    private boolean m_bEnabledCheckbox;
    private String m_sName;
    private String m_sDesc;
    public static final String DATA_MAP_ENABLED_CHECKBOX = "DataMapEnabledCheckbox";
    public static final String DATA_MAP_SINKS_TABLE = "DataMapSinksTable";
    public static final String DATA_MAP_SOURCES_TABLE = "DataMapSourcesTable";
    public static final String DATA_MAP_NAME = "DataMapName";
    public static final String DATA_MAP_DESC = "DataMapDesc";
    public static final String DATA_MAP_SELECTED_SINKS = "DataMapSelectedSink";
    public static final String DATA_MAP_SELECTED_SOURCES = "DataMapSelectedSource";
    private static final String SINKS_TABLE = "SinksTable";
    private static final String SOURCES_TABLE = "SourcesTable";

    public void panelAction(TaskActionEvent event) {
        ItemDescriptor[] id;
        int i;
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        if (command == null || command.equals("CANCEL")) {
            command = this.getMountPrefix() + "CancelButton";
        }
        this.userTaskManager.storeAllElements();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "PairingEditPanel");
        this.m_sName = this.m_sName.trim();
        request.setData(DATA_MAP_NAME, this.m_sName);
        request.setData(DATA_MAP_DESC, this.m_sDesc);
        request.setData(DATA_MAP_ENABLED_CHECKBOX, new Boolean(this.m_bEnabledCheckbox));
        if (this.m_iSinksTableSelection != null) {
            String[] selectedSinks = new String[this.m_iSinksTableSelection.length];
            i = 0;
            while (i < this.m_iSinksTableSelection.length) {
                id = this.userTaskManager.getRow(this.getMountPrefix() + SINKS_TABLE, this.m_iSinksTableSelection[i]);
                selectedSinks[i] = id[0].getTitle();
                ++i;
            }
            request.setData(DATA_MAP_SINKS_TABLE, selectedSinks);
        } else {
            request.setData(DATA_MAP_SINKS_TABLE, new String[0]);
        }
        if (this.m_iSourcesTableSelection != null) {
            String[] selectedSources = new String[this.m_iSourcesTableSelection.length];
            i = 0;
            while (i < this.m_iSourcesTableSelection.length) {
                id = this.userTaskManager.getRow(this.getMountPrefix() + SOURCES_TABLE, this.m_iSourcesTableSelection[i]);
                selectedSources[i] = id[0].getTitle();
                ++i;
            }
            request.setData(DATA_MAP_SOURCES_TABLE, selectedSources);
        } else {
            request.setData(DATA_MAP_SOURCES_TABLE, new String[0]);
        }
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData("CommandName", "OKButton");
        } else if (command.equals(this.getMountPrefix() + "CancelButton")) {
            request.setData("CommandName", "CancelButton");
        } else if (command.equals(this.getMountPrefix() + "SourcesButton")) {
            request.setData("CommandName", "SourcesButton");
        } else if (command.equals(this.getMountPrefix() + "SinksButton")) {
            request.setData("CommandName", "SinksButton");
        }
        if ((request.getData("CommandName").equals("OKButton") || request.getData("CommandName").equals("ApplyButton")) && (this.m_sName == null || this.m_sName.trim().equals(""))) {
            TaskMessage tm = new TaskMessage(this.userTaskManager, new NotificationMessageRes().getString("ntfy.error.blankname"), 1);
            tm.invoke();
            this.userTaskManager.setValue(this.getMountPrefix() + "Name", "");
            this.m_sName = "";
        } else {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        String[] sources;
        Trace.trace(TRACE_MASKT, "-> prepare()");
        String[] sinks = (String[])this.data.get(DATA_MAP_SINKS_TABLE);
        if (sinks == null) {
            sinks = new String[]{};
            this.data.put(DATA_MAP_SINKS_TABLE, sinks);
        }
        if ((sources = (String[])this.data.get(DATA_MAP_SOURCES_TABLE)) == null) {
            sources = new String[]{};
            this.data.put(DATA_MAP_SOURCES_TABLE, sources);
        }
        String[] selectedSinks = (String[])this.data.get(DATA_MAP_SELECTED_SINKS);
        String[] selectedSources = (String[])this.data.get(DATA_MAP_SELECTED_SOURCES);
        int[] selectedSinkIndices = null;
        int[] selectedSourceIndices = null;
        if (selectedSinks != null) {
            selectedSinkIndices = new int[selectedSinks.length];
        }
        if (selectedSources != null) {
            selectedSourceIndices = new int[selectedSources.length];
        }
        int selectedSinkIndex = 0;
        int selectedSourceIndex = 0;
        int i = 0;
        while (i < sinks.length) {
            if (selectedSinks != null) {
                int j = 0;
                while (j < selectedSinks.length) {
                    if (selectedSinks[j].equals(sinks[i])) {
                        Trace.trace(TRACE_MASKF, "found our sink");
                        selectedSinkIndices[selectedSinkIndex++] = i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sources.length) {
            if (selectedSources != null) {
                int j = 0;
                while (j < selectedSources.length) {
                    if (selectedSources[j].equals(sources[i2])) {
                        Trace.trace(TRACE_MASKF, "found our source");
                        selectedSourceIndices[selectedSourceIndex++] = i2;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (selectedSinkIndex > 0) {
            this.userTaskManager.setSelectedRows(this.getMountPrefix() + SINKS_TABLE, (int[])selectedSinkIndices.clone());
            this.m_iSinksTableSelection = (int[])selectedSinkIndices.clone();
        }
        if (selectedSourceIndex > 0) {
            this.userTaskManager.setSelectedRows(this.getMountPrefix() + SOURCES_TABLE, (int[])selectedSourceIndices.clone());
            this.m_iSourcesTableSelection = (int[])selectedSourceIndices.clone();
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        Boolean b = (Boolean)this.data.get(DATA_MAP_ENABLED_CHECKBOX);
        this.m_sName = (String)this.data.get(DATA_MAP_NAME);
        if (this.m_sName == null) {
            this.m_sName = "";
        }
        this.m_sDesc = (String)this.data.get(DATA_MAP_DESC);
        if (this.m_sDesc == null) {
            this.m_sDesc = "";
        }
        this.m_bEnabledCheckbox = b == null ? true : b;
        this.m_idSinksTable = new ItemDescriptor[0];
        this.m_cdSinksTableStructure = new ColumnDescriptor[0];
        this.m_iSinksTableSelection = new int[0];
        this.m_idSourcesTable = new ItemDescriptor[0];
        this.m_cdSourcesTableStructure = new ColumnDescriptor[0];
        this.m_iSourcesTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getSinksTableRowCount() {
        String[] sinks = (String[])this.data.get(DATA_MAP_SINKS_TABLE);
        return sinks.length;
    }

    public ItemDescriptor[] getSinksTableRowAt(int index) {
        String[] sinks = (String[])this.data.get(DATA_MAP_SINKS_TABLE);
        return new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + "SinksTable_" + index, sinks[index])};
    }

    public int getSourcesTableRowCount() {
        String[] sources = (String[])this.data.get(DATA_MAP_SOURCES_TABLE);
        return sources.length;
    }

    public ItemDescriptor[] getSourcesTableRowAt(int index) {
        String[] sources = (String[])this.data.get(DATA_MAP_SOURCES_TABLE);
        return new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + "SourcesTable_" + index, sources[index])};
    }

    public boolean isEnabledCheckbox() {
        return this.m_bEnabledCheckbox;
    }

    public void setEnabledCheckbox(boolean b) throws IllegalUserDataException {
        this.m_bEnabledCheckbox = b;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String s) throws IllegalUserDataException {
        this.m_sName = s;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String s) throws IllegalUserDataException {
        this.m_sDesc = s;
    }

    public ColumnDescriptor[] getSinksTableRowStructure() {
        return this.m_cdSinksTableStructure;
    }

    public int getSinksTableRowStatus() {
        return 3;
    }

    public void setSinksTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSinksTable = items;
    }

    public int[] getSinksTableSelection() {
        return this.m_iSinksTableSelection;
    }

    public void setSinksTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iSinksTableSelection = selected;
    }

    public ColumnDescriptor[] getSourcesTableRowStructure() {
        return this.m_cdSourcesTableStructure;
    }

    public int getSourcesTableRowStatus() {
        return 3;
    }

    public void setSourcesTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSourcesTable = items;
    }

    public int[] getSourcesTableSelection() {
        return this.m_iSourcesTableSelection;
    }

    public void setSourcesTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iSourcesTableSelection = selected;
    }
}

